////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int MakeSendPacket(char *rBuffer, const char *inBuffer, int inLength)
{
    int RPos = 0;
    int WPos = 0;

    int PacketHeader = PACKETHEADER;

    while(RPos < sizeof(int))
        rBuffer[WPos++] = ((char *)&PacketHeader)[RPos++];

    RPos = 0;

    while(RPos < sizeof(int))
        rBuffer[WPos++] = ((char *)&inLength)[RPos++];

    RPos = 0;

    while(RPos < inLength)
        rBuffer[WPos++] = inBuffer[RPos++];

	return WPos; // The total length of the packet
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int BreakRecvPacket(char *rBuffer, const char *inBuffer, int inLength, int *inoutOffset)
{
    int RPos = *inoutOffset;
    int WPos = 0;

    int PacketHeader = 0;
    int DataLen = 0;

    while(WPos < sizeof(int))
        ((char *)&PacketHeader)[WPos++] = inBuffer[RPos++];

    if(PacketHeader != PACKETHEADER)
    {
        WriteLog("(N/A) Received bad packet: Invalid header.");
        return -1;
    }

    WPos = 0;

    while(WPos < sizeof(int))
        ((char *)&DataLen)[WPos++] = inBuffer[RPos++];

    if(DataLen > MaxReceiveSize || DataLen < 0)
    {
        WriteLog("(N/A) Received bad packet: Invalid size.");
        return -1;
    }

    WPos = 0;

    while(WPos < DataLen && RPos < inLength)
        rBuffer[WPos++] = inBuffer[RPos++];

    *inoutOffset = (*inoutOffset + (WPos + sizeof(int)+ sizeof(int)));

    if(*inoutOffset >= inLength)
       *inoutOffset = -1;

	return DataLen; // The length of the rBuffer string
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

